/*!\file SpcDynamic.c
 * \brief: implementation of the SpcDynamic object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "./Constraint.h"
#include "../../shared/shared.h"

/*SpcDynamic constructors and destructor*/
/*FUNCTION SpcDynamic::SpcDynamic(){{{*/
SpcDynamic::SpcDynamic(){
	return;
}
/*}}}*/
/*FUNCTION SpcDynamic::SpcDynamic(int spc_sid,int spc_nodeid,...){{{*/
SpcDynamic::SpcDynamic(int spc_sid,int spc_nodeid, int spc_dof,int spc_analysis_type){

	sid=spc_sid;
	nodeid=spc_nodeid;
	dof=spc_dof;
	value=0;
	analysis_type=spc_analysis_type;
	isset=false;

	return;
}
/*}}}*/
/*FUNCTION SpcDynamic::~SpcDynamic{{{*/
SpcDynamic::~SpcDynamic(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION SpcDynamic::Echo {{{*/
void SpcDynamic::Echo(void){

	_printf_("SpcDynamic:" << "\n");
	_printf_("   sid: " << sid << "\n");
	_printf_("   nodeid: " << nodeid << "\n");
	_printf_("   dof: " << dof << "\n");
	_printf_("   value: " << value << "\n");
	_printf_("   isset: " <<(isset?"true":"false") << "\n");
	_printf_("   analysis_type: " << EnumToStringx(analysis_type) << "\n");
	return;
}
/*}}}*/
/*FUNCTION SpcDynamic::DeepEcho {{{*/
void SpcDynamic::DeepEcho(void){

	this->Echo();
	return;
}		
/*}}}*/
/*FUNCTION SpcDynamic::Id {{{*/
int    SpcDynamic::Id(void){ return sid; }
/*}}}*/
/*FUNCTION SpcDynamic::ObjectEnum{{{*/
int SpcDynamic::ObjectEnum(void){

	return SpcDynamicEnum;

}
/*}}}*/
/*FUNCTION SpcDynamic::copy {{{*/
Object* SpcDynamic::copy() {
	return new SpcDynamic(*this); 
}
/*}}}*/

/*Constraint virtual functions definitions: */
/*FUNCTION SpcDynamic::InAnalysis{{{*/
bool SpcDynamic::InAnalysis(int in_analysis_type){
	if (in_analysis_type==this->analysis_type) return true;
	else return false;
}
/*}}}*/
/*FUNCTION SpcDynamic::ConstrainNode{{{*/
void SpcDynamic::ConstrainNode(Nodes* nodes,Parameters* parameters){

	Node* node=NULL;

	/*Chase through nodes and find the node to which this SpcDynamic applys: */
	node=(Node*)nodes->GetObjectById(NULL,nodeid);

	/*Apply constraint: */
	if(node){ //in case the spc is dealing with a node on another cpu

		/*We should first check that the value has been set... (test306)*/
		node->ApplyConstraint(dof,value);
	}
}
/*}}}*/

/*SpcDynamic functions*/
/*FUNCTION SpcDynamic::GetDof {{{*/
int SpcDynamic::GetDof(){
	return dof;
}
/*}}}*/
/*FUNCTION SpcDynamic::GetNodeId {{{*/
int   SpcDynamic::GetNodeId(){

	return nodeid;
}
/*}}}*/
/*FUNCTION SpcDynamic::GetValue {{{*/
IssmDouble SpcDynamic::GetValue(){
	_assert_(this->isset);
	_assert_(!xIsNan<IssmDouble>(value));
	return value;
}
/*}}}*/
/*FUNCTION SpcDynamic::SetDynamicConstraint {{{*/
void SpcDynamic::SetDynamicConstraint(Nodes* nodes,IssmDouble* yg_serial){

	int pos;

	Node* node=(Node*)nodes->GetObjectById(NULL,nodeid);
	pos=node->GetDof(dof-1,GsetEnum);

	this->value=yg_serial[pos];
	this->isset=true;
}
/*}}}*/
