/*\file Print.h
 *\brief: print I/O for ISSM
 */

#ifndef _ISSM_PRINT_H_
#define _ISSM_PRINT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif 

#include <string>
#include <iostream>
#include <sstream>
#include <iomanip>

using namespace std;
/*macros:*/
/* _printLine_ {{{*/
/* macro to print a line, adds std::endl, only on cpu 0 */
#define _printLine_(StreamArgs)\
  do{std::ostringstream aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy; \
	  aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy << StreamArgs << std::ends; \
	  PrintfFunction3(aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy.str());}while(0)
/*}}}*/
/* _printString_ {{{*/
/* macro to print some string. Only on cpu0 */
#define _printString_(StreamArgs)\
  do{std::ostringstream aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy; \
	  aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy << StreamArgs << std::ends; \
	  PrintfFunction4(aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy.str());}while(0)
/*}}}*/
/* _pprintLine_ {{{*/
/* macro to print a line, adds std::endl, only on cpu 0 */
#define _pprintLine_(StreamArgs)\
  do{std::ostringstream aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy; \
	  aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy << StreamArgs << std::ends; \
	  PrintfFunction(aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy.str());}while(0)
/*}}}*/
/* _pprintString_ {{{*/
/* macro to print some string. Only on cpu0 */
#define _pprintString_(StreamArgs)\
  do{std::ostringstream aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy; \
	  aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy << StreamArgs << std::ends; \
	  PrintfFunction2(aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy.str());}while(0)
/*}}}*/

/* _printLine_ {{{*/
/* macro to print a line, adds std::endl, only on cpu 0 */
#define _printLine_(StreamArgs)\
  do{std::ostringstream aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy; \
	  aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy << StreamArgs << std::ends; \
	  PrintfFunction3(aLoNgAnDwEiRdLoCaLnAmeFoRtHiSmAcRoOnLy.str());}while(0)
/*}}}*/

/*functions: */
int PrintfFunction(const char* format,...);
int PrintfFunction(const string & message);
int PrintfFunction2(const string & message);
int PrintfFunction3(const string & message);
int PrintfFunction4(const string & message);

#endif	
