      subroutine ojrule(dk,bcin)
      implicit double precision(a-h,o-z)
      parameter (nhank = 1024)
      double precision yvalue(nhank),bcin(nhank)
      double precision wok, rpos
      double precision pset(7)
      double precision aswokm, distrad
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      common /blockrad/ distrad
      common /blockp/ pset
      common /blockn/ irate
      common /blocks/ aswokm
      data zero /0.0d0/, one /1.0d0/, two /2.0d0/, three /3.0d0/,
     1rescal/ 1.0d0/
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      iprate = irate + 1
      bath = dk / three
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c rpose should be normalized wrt lithosphere thickness 
c give r is normalized dist_rad :: r == dist_rad / h
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      r = distrad / (pset(1) / 1.0d3)
      rpos = r 
      ak = zero
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c form the yvalue's for the Simpson's rule formulas
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      do 425 ik = 1, nhank
      ak = ak + dk
      rak = ak * r
      rarg = dbesj0( rak )
      yvalue(ik) = bcin(ik) * rarg
  425 continue
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c correct to end point val. in Simp. Rule
c      yvalue(nhank) = bcin(nhank) * rarg / two
c find the area under the curve using the Simpson's rule formulas
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      sumde = zero
      do 300 int = 1, nhank
      intp1 = int + 1
      ide = 2 + ( (-1)**intp1 + 1 )
      fide = dfloat(ide)
      sumde = ( fide * yvalue(int) ) + sumde
  300 continue
      wok = bath * sumde
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      go to (1000,2000), iprate
 1000 call wolfc(rpos,wok)
      go to 999
 2000 call rates(rpos,wok)
  999 return

      end
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      subroutine wolfc(rpos,wok)
      double precision wok, rpos
      double precision pset(7)
      double precision swok,asrpos, aswokm
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      common /blockp/ pset
      common /blocks/ aswokm
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c make single prec. and return to dimensional units.
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      hscale = sngl(pset(1))
      hsckm = hscale / 1.0e3
      swok = hscale * sngl(wok)
      asrpos = hsckm * sngl(rpos)
      aswokm = swok

      return
      end
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      subroutine rates(rpos,wok)
      double precision wok, rpos
      double precision pset(7)
      double precision swok, asrpos, aswokm
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      common /blockp/ pset
      common /blocks/ aswokm
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      data ngyo /050201/
      data ngyii /050201/
      data yearco /3.15576d7/
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c make single prec. and return to dimensional units.
c ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      hscale = sngl(pset(1))
      hsckm = hscale / 1.0e3
      swok = (hscale * yearco * 1.0e3 * sngl(wok))
     1                  * ( sngl(pset(4))/ sngl(pset(2)) )
      asrpos = hsckm * sngl(rpos)
      aswokm = swok

      return
      end
