/*!\file TriaHook.c
 * \brief: implementation of the TriaHook object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION TriaHook::TriaHook(){{{*/
TriaHook::TriaHook(){
	numanalyses=UNDEF;
	this->hnodes    = NULL;
	this->hvertices = NULL;
	this->hmaterial = NULL;
	this->hmatpar   = NULL;
}
/*}}}*/
/*FUNCTION TriaHook::~TriaHook(){{{*/
TriaHook::~TriaHook(){
	int i;

	for(i=0;i<this->numanalyses;i++){
		if (this->hnodes[i]) delete this->hnodes[i];
	}
	delete [] hnodes;
	delete hvertices;
	delete hmaterial;
	delete hmatpar;

}
/*}}}*/
/*FUNCTION TriaHook::TriaHook(int in_numanalyses,int element_id, int matpar_id){{{*/
TriaHook::TriaHook(int in_numanalyses,int element_id, IoModel* iomodel){

	/*intermediary: */
	int matpar_id;
	int material_id;
	int tria_vertex_ids[3];

	/*retrieve material_id: */
	iomodel->Constant(&matpar_id,MeshNumberofelementsEnum); matpar_id++;

	/*retrive material_id*/
	material_id = element_id;

	/*retrieve vertices ids*/
	for(int i=0;i<3;i++){ 
		tria_vertex_ids[i]=reCast<int>(iomodel->Data(MeshElementsEnum)[3*(element_id-1)+i]);
	}

	this->numanalyses = in_numanalyses;
	this->hnodes      = new Hook*[in_numanalyses];
	this->hvertices   = new Hook(&tria_vertex_ids[0],3);
	this->hmaterial   = new Hook(&material_id,1);
	this->hmatpar     = new Hook(&matpar_id,1);

	//Initialize hnodes as NULL
	for(int i=0;i<this->numanalyses;i++){
		this->hnodes[i]=NULL;
	}

}
/*}}}*/

/*FUNCTION TriaHook::SetHookNodes{{{*/
void TriaHook::SetHookNodes(int* node_ids,int analysis_counter){

	/*initialize hook*/
	this->hnodes[analysis_counter]=new Hook(node_ids,3);
}
/*}}}*/
