/*!\file DependentObject.c
 * \brief: implementation of the DependentObject object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./classes.h"
#include "shared/shared.h"

/*DependentObject constructors and destructor*/
/*FUNCTION DependentObject::DependentObject(){{{*/
DependentObject::DependentObject(){
	this->name=NoneEnum;
	this->type=0;
	this->index=-1;
}
/*}}}*/
/*FUNCTION DependentObject::DependentObject(int in_name, int in_type, int in_index){{{*/
DependentObject::DependentObject(int in_name, int in_type,int in_index){

	this->name=in_name;
	this->type=in_type;
	this->index=in_index;
	if(in_type!=0 && in_type!=1)_error_("cannot create an DependentObject of type " << in_type);
	if(in_type==1)_error_("not implemented yet!");

}
/*}}}*/
/*FUNCTION DependentObject::~DependentObject() {{{*/
DependentObject::~DependentObject(){ //destructor
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DependentObject::Echo{{{*/
void DependentObject::Echo(void){

	_printLine_("DependentObject:");
	_printLine_("   name: " << EnumToStringx(this->name));
	if(this->type==0)
		_printLine_("   type: scalar");
	else if(this->type==1)
		_printLine_("   type: vertex");
	else
		_error_(" unknown type: " << this->type);
	if(this->index>=0) _printLine_("   index: " << this->index);
}
/*}}}*/
/*FUNCTION DependentObject::DeepEcho{{{*/
void DependentObject::DeepEcho(void){
	this->Echo();
}
/*}}}*/
/*FUNCTION DependentObject::Id{{{*/
int    DependentObject::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DependentObject::ObjectEnum{{{*/
int DependentObject::ObjectEnum(void){

	return DependentObjectEnum;

}
/*}}}*/
/*FUNCTION DependentObject::copy{{{*/
Object* DependentObject::copy(void) { 
	return new DependentObject(name,type,index);
} /*}}}*/

/*DependentObject methods: */
/*FUNCTION DependentObject::NumDependents{{{*/
int  DependentObject::NumDependents(void){

	/*Branch according to the type of variable: */
	if(type==0){ /*scalar:*/
		return 1;
	}
	else if(type==1){ /* vector:*/
		_error_("not implemented yet!");
	}
	else _error_("should not have a type of " << type);
}
/*}}}*/
/*FUNCTION DependentObject::Responsex{{{*/
void  DependentObject::Responsex(IssmDouble* poutput_value,FemModel* femmodel){

	if(this->name==MassFluxEnum){

		/*to identify the mass flux that will be computed, we need the index of the profile: */
		femmodel->parameters->SetParam(this->index,IndexEnum);
	}

	femmodel->Responsex(poutput_value,this->name,false,0);

}
/*}}}*/
