/*!\file: IndependentObject.h
 * \brief prototype for IndependentObject.h
 */ 

#ifndef _INDEPENDENTOBJECT_H_
#define  _INDEPENDENTOBJECT_H_

/*{{{*/
#include "./Object.h"
#include "../shared/shared.h"
/*}}}*/
class IoModel;

class IndependentObject: public Object{

	public:

		int name;
		int type;  /*0: scalar, 1: vertex*/
		int numberofvertices;

		/*IndependentObject constructors, destructors {{{*/
		IndependentObject();
		IndependentObject(int name, int type, int numberofvertices);
		~IndependentObject();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy(void);
		/*}}}*/
		/*IndependentObject methods: {{{*/
		void FetchIndependent(IoModel* iomodel);
		int  NumIndependents(void);
		void FillIndependents(IssmDouble** data, IssmDouble* xp);
		/*}}}*/

};
#endif //ifndef _INDEPENDENTOBJECT_H_
