/*!\file IntParam.c
 * \brief: implementation of the IntParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*IntParam constructors and destructor*/
/*FUNCTION IntParam::IntParam(){{{*/
IntParam::IntParam(){
	return;
}
/*}}}*/
/*FUNCTION IntParam::IntParam(int enum_type,IssmInt value){{{*/
IntParam::IntParam(int in_enum_type,IssmInt in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION IntParam::~IntParam(){{{*/
IntParam::~IntParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntParam::Echo {{{*/
void IntParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION IntParam::DeepEcho{{{*/
void IntParam::DeepEcho(void){

	_printLine_("IntParam:");
	_printLine_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   value: " << this->value);
}
/*}}}*/
/*FUNCTION IntParam::Id{{{*/
int    IntParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntParam::ObjectEnum{{{*/
int IntParam::ObjectEnum(void){

	return IntParamEnum;

}
/*}}}*/
/*FUNCTION IntParam::copy{{{*/
Object* IntParam::copy() {

	return new IntParam(this->enum_type,this->value);

}
/*}}}*/

/*IntParam virtual functions definitions: */
/*FUNCTION IntParam::GetParameterName{{{*/
void IntParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION IntParam::UnitConversion{{{*/
void  IntParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
