/*!\file PentaP1ElementResult.c
 * \brief: implementation of the PentaP1ElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"

/*PentaP1ElementResult constructors and destructor*/
/*FUNCTION PentaP1ElementResult::PentaP1ElementResult(){{{*/
PentaP1ElementResult::PentaP1ElementResult(){
	return;
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::PentaP1ElementResult(int in_enum_type,IssmDouble* in_values,int in_step, IssmDouble in_time){{{*/
PentaP1ElementResult::PentaP1ElementResult(int in_enum_type,IssmDouble* in_values,int in_step, IssmDouble in_time){

	int i;

	enum_type=in_enum_type;
	for(i=0;i<6;i++)values[i]=in_values[i];
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::~PentaP1ElementResult(){{{*/
PentaP1ElementResult::~PentaP1ElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION PentaP1ElementResult::Echo {{{*/
void PentaP1ElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::DeepEcho{{{*/
void PentaP1ElementResult::DeepEcho(void){

	_printLine_("PentaP1ElementResult:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   values: [" << this->values[0] << " " << this->values[1] << " " << this->values[2] << " " << this->values[3] << " " << this->values[4] << " " << this->values[5] << "]");
	_printLine_("   step: " << this->step);
	_printLine_("   time: " << this->time);

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::Id{{{*/
int    PentaP1ElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION PentaP1ElementResult::ObjectEnum{{{*/
int PentaP1ElementResult::ObjectEnum(void){

	return PentaP1ElementResultEnum;

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::copy{{{*/
Object* PentaP1ElementResult::copy() {

	return new PentaP1ElementResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION PentaP1ElementResult::InstanceEnum{{{*/
int PentaP1ElementResult::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::SpawnTriaElementResult{{{*/
ElementResult* PentaP1ElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	TriaP1ElementResult* outresult=NULL;
	IssmDouble newvalues[3];

	/*Loop over the new indices*/
	for(int i=0;i<3;i++){

		/*Check index value*/
		_assert_(indices[i]>=0 && indices[i]<6);

		/*Assign value to new result*/
		newvalues[i]=this->values[indices[i]];
	}

	/*Create new Tria result*/
	outresult=new TriaP1ElementResult(this->enum_type,&newvalues[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::ProcessUnits{{{*/
void PentaP1ElementResult::ProcessUnits(Parameters* parameters){

	UnitConversion(this->values,6,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::NumberOfNodalValues{{{*/
int PentaP1ElementResult::NumberOfNodalValues(void){
	return 6;
}
/*}}}*/
/*FUNCTION PentaP1ElementResult::PatchFill{{{*/
void PentaP1ElementResult::PatchFill(int row, Patch* patch){

	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,6);

}
/*}}}*/
/*FUNCTION PentaP1ElementResult::GetVectorFromResults{{{*/
void PentaP1ElementResult::GetVectorFromResults(Vector<IssmDouble>* vector,int* doflist,int* connectivitylist,int numdofs){

	IssmDouble data[6];

	if(numdofs!=6)_error_("Result " << EnumToStringx(this->enum_type) << " is a PentaP1ElementResult and cannot write vector of " << numdofs << " dofs");
	for(int i=0;i<6;i++) data[i]=this->values[i]/(IssmDouble)connectivitylist[i];
	vector->SetValues(numdofs,doflist,&data[0],ADD_VAL);

} /*}}}*/
/*FUNCTION PentaP1ElementResult::GetElementVectorFromResults{{{*/
void PentaP1ElementResult::GetElementVectorFromResults(Vector<IssmDouble>* vector,int dof){

	_error_("Result " << EnumToStringx(enum_type) << " is a PentaP1ElementResult and should not write vector of size numberofelemenrs");
} /*}}}*/
