/*!\file:  AverageFilter.cpp
 * \brief fill holes in matlab velocity array
	this matlab module is an adaptation of a routine written by Robber 
	Crippen.  The original routine was designed for the SRTM mission at JPL, 
	and can be found in the current directory, under the name 
	AverageFilterCrippen.  It fills void holes in an image, using an interpolation 
	algorithm, and optionnally a smoothing algorithm. 
	This matlab module extends the Crippen routine to be used in Matlab, 
	using double arrays found in the workspace, and loaded directly into memory.
*/

#include "./AverageFilter.h"

void AverageFilterUsage(void){/*{{{*/
	_printLine_("   AverageFilter usage:");
	_printLine_("   [image_out]=AverageFilter(image_in,pixels);\n");
	_printLine_("   where:");
	_printLine_("      image_in in double format");
	_printLine_("      pixels: characteristic size of smoothing");
	_printLine_("      image_out in double format");
	_printLine_("");
}/*}}}*/
WRAPPER(AverageFilter){

	int i,j;

	/* required input: */
	double* imagein=NULL;
	int     imagein_rows,imagein_cols;
	int     smooth;

	/* output: */
	double* imageout=NULL;
	int     imageout_rows,imageout_cols;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&AverageFilterUsage);

	/*Fetch data: */
	FetchData(&imagein,&imagein_rows,&imagein_cols,IMAGEIN);
	FetchData(&smooth,SMOOTH);
	
	/*Run core hole filler routine: */
	AverageFilterx( &imageout,imagein,imagein_rows,imagein_cols,smooth);

	/* output: */
	WriteData(IMAGEOUT,imageout,imagein_rows,imagein_cols);

	/*free ressources: */
	xDelete<double>(imagein);
	xDelete<double>(imageout);

	/*end module: */
	MODULEEND();
}
