/*!\file EdgeDetection.c
 * \brief: edge detection for a boolean image
*/
	
#include "./EdgeDetection.h"

void EdgeDetectionUsage(void){/*{{{*/
	_pprintLine_("EDGEDETECTION usage- detect edges of a boolean image");
	_pprintLine_("");
	_pprintLine_("   Usage:");
	_pprintLine_("      contours=EdgeDetection(image);");
	_pprintLine_("");
	_pprintLine_("      image: boolean matrix");
	_pprintLine_("");
	_pprintLine_("   Example:");
	_pprintLine_("      load('velocities.mat');");
	_pprintLine_("      md.inversion.vx_obs=EdgeDetection(x_n,y_m,vx,md.mesh.x,md.mesh.y,0);");
	_pprintLine_("");
}/*}}}*/
WRAPPER(EdgeDetection){

	/*input: */
	bool *image = NULL;
	int   M,N;

	/* output: */
	DataSet* contours=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&EdgeDetectionUsage);

	/*Input datasets: */
	FetchData(&image,&M,&N,IMAGE);

	/*Initialize output: */
	contours=new DataSet();

	/* Run core computations: */
	EdgeDetectionx(contours,image,M,N);

	/*Write data: */
	WriteData(CONTOURS,contours);

	/*Clean up*/
	xDelete<bool>(image);
	delete contours;

	/*end module: */
	MODULEEND();
}
