/*! \file  ContourtoNodes
    \brief: takes a  contour file, and figures out which nodes  (x,y list)
*/
	
#include "./ContourToNodes.h"

void ContourToNodesUsage(void){/*{{{*/
	_printLine_("   usage:");
	_printLine_("   [flags]=ContourToNodes(x,y,contourname,edgevalue);\n");
	_printLine_("   where:");
	_printLine_("      x,y: list of nodes.");
	_printLine_("      contourname: name of .exp file containing the contours, or resulting structure from call to expread.");
	_printLine_("      edgevalue: integer (0, 1 or 2) defining the value associated to the nodes on the edges of the polygons.");
	_printLine_("      flags: vector of flags (0 or 1), of size nods.");
	_printLine_("");
}/*}}}*/
WRAPPER(ContourToNodes){

	/* input: */
	int      edgevalue,nods;
	double  *x           = NULL;
	double  *y           = NULL;
	char    *contourname = NULL;
	DataSet *contours    = NULL;

	/* output: */
	double *flags = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CHECKARGUMENTS(NLHS,NRHS,&ContourToNodesUsage);
	
	/*Fetch inputs: */
	FetchData(&x,&nods,NULL,XHANDLE);
	FetchData(&y,NULL,NULL,YHANDLE);
	FetchData(&edgevalue,EDGEVALUE);
	FetchData(&contours,CONTOUR);

	/*Run x layer */
	ContourToNodesx(&flags,x,y,nods,contours,edgevalue);

	/* output: */
	WriteData(FLAGS,flags,nods);

	/*Clean up*/
	xDelete<double>(x);
	xDelete<double>(y);
	xDelete<char>(contourname);
	delete contours;

	/*end module: */
	MODULEEND();
}
