/*! \file CreateLoadsHydrologyDCEfficient.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsHydrologyDCEfficient(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	bool     isefficientlayer;
	int      hydrology_model;
	int      numberofvertices;
	Pengrid *pengrid = NULL;

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Fetch parameters: */
	iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads();

	/*Do we really want DC?*/
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum){
		*ploads=loads;
		return;
	}

	/*Do we want an efficient layer*/
	iomodel->Constant(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	if(!isefficientlayer){
		*ploads=loads;
		return;
	}

	/*Nothing for now*/

	/*Assign output pointer: */
	*ploads=loads;
}
