/*
 * CreateConstraintsHydrologyDCEfficient.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"
#include "../../IoModelToConstraintsx/IoModelToConstraintsx.h"

void	CreateConstraintsHydrologyDCEfficient(Constraints** pconstraints, IoModel* iomodel){

	/*Recover pointer: */
	bool         isefficientlayer;
	int          hydrology_model;
	Constraints* constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints();

	/*Do we really want DC?*/
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum){
		*pconstraints=constraints;
		return;
	}

	/*Do we want an efficient layer*/
	iomodel->Constant(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	if(!isefficientlayer){
		*pconstraints=constraints;
		return;
	}

	IoModelToConstraintsx(constraints,iomodel,HydrologydcSpceplHeadEnum,HydrologyDCEfficientAnalysisEnum);

	/*Assign output pointer: */
	*pconstraints=constraints;
}
