/*
 * UpdateElementsDiagnosticHutter:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticHutter(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	int    numberofelements;
	bool   ishutter;

	/*Fetch data needed: */
	iomodel->Constant(&numberofelements,MeshNumberofelementsEnum);
	iomodel->Constant(&ishutter,FlowequationIshutterEnum);

	/*Now, is the flag hutter on? otherwise, do nothing: */
	if (!ishutter)return;

	iomodel->FetchData(2,MeshElementsEnum,FlowequationElementEquationEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,GeometryHydrostaticRatioEnum);

	/*Free data: */
	iomodel->DeleteData(2,MeshElementsEnum,FlowequationElementEquationEnum);
}
