/*!\file Shp2Exp.h
 * \brief: prototype for shp to exp file conversion mex module.
 */

#ifndef _SHP2EXP_H
#define _SHP2EXP_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

#include "../bindings.h"
#include "../../c/main/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__  "Shp2Exp"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define SHP_IN  prhs[0]
#define EXP_IN  prhs[1]
/* serial output macros: */
#define RET_OUT (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define SHP_IN PyTuple_GetItem(args,0)
#define EXP_IN PyTuple_GetItem(args,1)
/* serial output macros: */
#define RET_OUT output,0
#endif

/* serial arg counts: */
#undef NRHS
#define NRHS  2
#undef NLHS
#define NLHS  1

#endif

