/*
 * CreateConstraintsThermal.c:
 */

#include "../../../shared/io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"
#include "../../IoModelToConstraintsx/IoModelToConstraintsx.h"

void	CreateConstraintsThermal(Constraints** pconstraints, IoModel* iomodel){

	/*Fetch parameters: */
	int    dim;
	iomodel->Constant(&dim,MeshDimensionEnum);

	/*Recover pointer: */
	Constraints* constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints();

	/*Only 3d mesh supported*/
	if (dim==3){
		IoModelToConstraintsx(constraints,iomodel,ThermalSpctemperatureEnum,ThermalAnalysisEnum);
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
