#include "../../../toolkits/toolkits.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../shared/io/io.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"
#include "../../IoModelToConstraintsx/IoModelToConstraintsx.h"

void	CreateConstraintsPrognostic(Constraints** pconstraints, IoModel* iomodel){

	/*Fetch parameters: */
	int stabilization;
	iomodel->Constant(&stabilization,PrognosticStabilizationEnum);

	/*Recover pointer: */
	Constraints* constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints();

	/*Do not add constraints in DG, they are weakly imposed*/
	if(stabilization!=3){
		IoModelToConstraintsx(constraints,iomodel,PrognosticSpcthicknessEnum,PrognosticAnalysisEnum);
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
