/*!\file: CreateParametersHydrologyShreve.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../toolkits/toolkits.h"
#include "../../../shared/io/io.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersHydrologyShreve(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){

	Parameters *parameters = NULL;
	int         hydrology_model;
	bool        isefficientlayer;

	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);

	/*Now, do we really want Shreve?*/
	if(hydrology_model!=HydrologyshreveEnum){
		*pparameters=parameters;
		return;
	}

	parameters->AddObject(new IntParam(HydrologyModelEnum,hydrology_model));
	parameters->AddObject(iomodel->CopyConstantObject(HydrologyshreveStabilizationEnum));

	/*Assign output pointer: */
	*pparameters=parameters;
}
