/*
 * UpdateElementsHydrologyDCInefficient:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../shared/io/io.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	UpdateElementsHydrologyDCInefficient(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	int    hydrology_model;
	int    numberofelements;

	/*Fetch data needed: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	iomodel->Constant(&numberofelements,MeshNumberofelementsEnum);

	/*Now, do we really want DC?*/
	if(hydrology_model!=HydrologydcEnum) return;

	/*Fetch data needed: */
	iomodel->FetchData(1,MeshElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,MaskElementonfloatingiceEnum);
	iomodel->FetchDataToInput(elements,MeshElementonbedEnum);
	iomodel->FetchDataToInput(elements,MeshElementonsurfaceEnum);
	iomodel->FetchDataToInput(elements,MaskElementonwaterEnum);
	iomodel->FetchDataToInput(elements,BasalforcingsMeltingRateEnum);
	iomodel->FetchDataToInput(elements,SedimentHeadEnum);

	/*Free data: */
	iomodel->DeleteData(1,MeshElementsEnum);
}
