/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../shared/io/io.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticVert(Constraints** pconstraints, IoModel* iomodel){

	/*Intermediary*/
	int i;
	int dim;
	int count;
	IssmDouble yts;
	int    numberofvertices;

	/*Fetch parameters: */
	iomodel->Constant(&dim,MeshDimensionEnum);
	iomodel->Constant(&yts,ConstantsYtsEnum);
	iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);

	/*Recover pointer: */
	Constraints* constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints();

	/*return if 2d mesh*/
	if(dim==2){
		*pconstraints=constraints;
		return;
	}

	/*Fetch data: */
	iomodel->FetchData(2,DiagnosticSpcvzEnum,FlowequationBorderstokesEnum);

	/*Initialize counter*/
	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<numberofvertices;i++){

		/*keep only this partition's nodes:*/
		if(iomodel->my_vertices[i]){

			if (reCast<int,IssmDouble>(iomodel->Data(FlowequationBorderstokesEnum)[i])){
				constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,0,DiagnosticVertAnalysisEnum)); //spc to zero as vertical velocity is done in Horiz for Stokes
				count++;
			}
			else if (!xIsNan<IssmDouble>(iomodel->Data(DiagnosticSpcvzEnum)[i])){
				constraints->AddObject(new SpcStatic(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,
								iomodel->Data(DiagnosticSpcvzEnum)[i]/yts,DiagnosticVertAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
				count++;

			}
		} 
	}

	/*Free data: */
	iomodel->DeleteData(2,DiagnosticSpcvzEnum,FlowequationBorderstokesEnum);

	/*Assign output pointer: */
	*pconstraints=constraints;
}
