/*!\file FileParam.c
 * \brief: implementation of the FileParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../shared/shared.h"
/*}}}*/

/*FileParam constructors and destructor*/
/*FUNCTION FileParam::FileParam(){{{*/
FileParam::FileParam(){
	return;
}
/*}}}*/
/*FUNCTION FileParam::FileParam(int enum_type,FILE *value){{{*/
FileParam::FileParam(int in_enum_type,FILE* in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION FileParam::~FileParam(){{{*/
FileParam::~FileParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION FileParam::Echo {{{*/
void FileParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION FileParam::DeepEcho{{{*/
void FileParam::DeepEcho(void){

	_printLine_("FileParam:");
	_printLine_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   value: " << this->value);
}
/*}}}*/
/*FUNCTION FileParam::Id{{{*/
int    FileParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION FileParam::ObjectEnum{{{*/
int FileParam::ObjectEnum(void){

	return FileParamEnum;

}
/*}}}*/
/*FUNCTION FileParam::copy{{{*/
Object* FileParam::copy() {

	return new FileParam(this->enum_type,this->value);

}
/*}}}*/

/*FileParam virtual functions definitions: */
/*FUNCTION FileParam::GetParameterName{{{*/
void FileParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION FileParam::UnitConversion{{{*/
void  FileParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
