/*!\file DoubleVecParam.c
 * \brief: implementation of the DoubleVecParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../shared/shared.h"
/*}}}*/

/*DoubleVecParam constructors and destructor*/
/*FUNCTION DoubleVecParam::DoubleVecParam(){{{*/
DoubleVecParam::DoubleVecParam(){
	return;
}
/*}}}*/
/*FUNCTION DoubleVecParam::DoubleVecParam(int enum_type,IssmDoubleVec values,int M){{{*/
DoubleVecParam::DoubleVecParam(int in_enum_type,IssmDouble* in_values, int in_M){

	enum_type=in_enum_type;
	M=in_M;

	values=xNew<IssmDouble>(M);
	xMemCpy<IssmDouble>(values,in_values,M);
}
/*}}}*/
/*FUNCTION DoubleVecParam::~DoubleVecParam(){{{*/
DoubleVecParam::~DoubleVecParam(){
	xDelete<IssmDouble>(values);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleVecParam::Echo {{{*/
void DoubleVecParam::Echo(void){

	_printLine_("DoubleVecParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   vector size: " << this->M);

}
/*}}}*/
/*FUNCTION DoubleVecParam::DeepEcho{{{*/
void DoubleVecParam::DeepEcho(void){

	int i;

	_printLine_("DoubleVecParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   vector size: " << this->M);
	for(i=0;i<this->M;i++){
		_printLine_(i << " " << this->values[i]);
	}
}
/*}}}*/
/*FUNCTION DoubleVecParam::Id{{{*/
int    DoubleVecParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleVecParam::ObjectEnum{{{*/
int DoubleVecParam::ObjectEnum(void){

	return DoubleVecParamEnum;

}
/*}}}*/
/*FUNCTION DoubleVecParam::copy{{{*/
Object* DoubleVecParam::copy() {

	return new DoubleVecParam(this->enum_type,this->values,this->M);

}
/*}}}*/

/*DoubleVecParam virtual functions definitions: */
/*FUNCTION DoubleVecParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){{{*/
void  DoubleVecParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){
	IssmDouble* output=NULL;
	int M;

	M=this->M;
	output=xNew<IssmDouble>(M);
	xMemCpy<IssmDouble>(output,values,M);

	/*Assign output pointers:*/
	if(pM) *pM=M;
	*pIssmDoublearray=output;
}
/*}}}*/
/*FUNCTION DoubleVecParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){{{*/
void  DoubleVecParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM,int* pN){
	IssmDouble* output=NULL;
	int M;
	int N;

	N=1;
	M=this->M;
	output=xNew<IssmDouble>(M);
	xMemCpy<IssmDouble>(output,values,M);

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pIssmDoublearray=output;
}
/*}}}*/
/*FUNCTION DoubleVecParam::GetParameterValue(int** pintarray,int* pM){{{*/
void  DoubleVecParam::GetParameterValue(int** pintarray,int* pM){
	_error_("DoubleVec param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of int");
}
/*}}}*/
/*FUNCTION DoubleVecParam::GetParameterName{{{*/
void DoubleVecParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DoubleVecParam::SetValue{{{*/
void  DoubleVecParam::SetValue(IssmDouble* IssmDoublearray,int in_M){

	/*avoid leak: */
	xDelete<IssmDouble>(this->values);

	this->values=xNew<IssmDouble>(in_M);
	xMemCpy<IssmDouble>(this->values,IssmDoublearray,in_M);

	this->M=in_M;
}
/*}}}*/
/*FUNCTION DoubleVecParam::UnitConversion{{{*/
void  DoubleVecParam::UnitConversion(int direction_enum){
	::UnitConversion(this->values,this->M,direction_enum,this->enum_type);
}
/*}}}*/
