/*!\file KML_Placemark.cpp
 * \brief: implementation of the kml_placemark object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../shared/shared.h"
#include "../../../shared/io/io.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Placemark::KML_Placemark(){{{*/
KML_Placemark::KML_Placemark(){

	geometry  =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Placemark::~KML_Placemark(){{{*/
KML_Placemark::~KML_Placemark(){

	if (geometry) {
		delete geometry;
		geometry  =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Placemark::Echo {{{*/
void  KML_Placemark::Echo(){

	bool  flag=true;

	if(flag) _pprintLine_("KML_Placemark:");
	KML_Feature::Echo();

	if(flag) _pprintLine_("      geometry: (size=" << geometry->Size() << ")");

	return;
}
/*}}}*/
/*FUNCTION KML_Placemark::DeepEcho {{{*/
void  KML_Placemark::DeepEcho(){

	char  indent[81]="";

	KML_Placemark::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION KML_Placemark::DeepEcho {{{*/
void  KML_Placemark::DeepEcho(const char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	if(flag) _pprintLine_(indent << "KML_Placemark:");
	KML_Feature::DeepEcho(indent);

/*  loop over the geometry elements for the placemark  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));
	strcat(indent2,"  ");

	if (geometry->Size())
		for (i=0; i<geometry->Size(); i++) {
			if(flag) _pprintLine_(indent << "      geometry: -------- begin [" << i << "] --------");
			((KML_Geometry *)geometry->GetObjectByOffset(i))->DeepEcho(indent2);
			if(flag) _pprintLine_(indent << "      geometry: --------  end  [" << i << "] --------");
		}
	else
		if(flag) _pprintLine_(indent << "      geometry: [empty]");

	return;
}
/*}}}*/
/*FUNCTION KML_Placemark::Write {{{*/
void  KML_Placemark::Write(FILE* filout,const char* indent){

	int   i;
	char  indent2[81];

	fprintf(filout,"%s<Placemark",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_Feature::Write(filout,indent);

/*  loop over the geometry elements for the placemark  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	for (i=0; i<geometry->Size(); i++)
		((KML_Geometry *)geometry->GetObjectByOffset(i))->Write(filout,indent2);

	fprintf(filout,"%s</Placemark>\n",indent);

	return;
}
/*}}}*/
/*FUNCTION KML_Placemark::Read {{{*/
void  KML_Placemark::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;
	KML_Object*  kobj;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</Placemark",11)) {
			xDelete<char>(kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
		  {_error_("KML_Placemark::Read -- Unexpected closing tag " << kstri << ".\n");}
		else if (strncmp(kstri,"<",1))
		  {_error_("KML_Placemark::Read -- Unexpected field \"" << kstri << "\".\n");}

		else if (!strncmp(kstri,"<Point", 6)) {
			kobj=(KML_Object*)new KML_Point();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<LineString",11)) {
			kobj=(KML_Object*)new KML_LineString();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<LinearRing",11)) {
			kobj=(KML_Object*)new KML_LinearRing();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Polygon", 8)) {
			kobj=(KML_Object*)new KML_Polygon();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<MultiGeometry",14)) {
			kobj=(KML_Object*)new KML_MultiGeometry();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<",1))
			KML_Feature::Read(fid,kstri);

		xDelete<char>(kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xDelete<char>(pcom[ncom-1]);
	xDelete<char*>(pcom);

	return;
}
/*}}}*/
/*FUNCTION KML_Placemark::WriteExp {{{*/
void  KML_Placemark::WriteExp(FILE* fid,const char* nstr,int sgn,double cm,double sp){

	int   i;
	char  nstr2[81];

/*  loop over the geometry elements for the placemark  */

	for (i=0; i<geometry->Size(); i++) {
		if (strlen(nstr))
			sprintf(nstr2,"%s %s",nstr,name);
		else
			sprintf(nstr2,"%s",name);

		((KML_Object *)geometry->GetObjectByOffset(i))->WriteExp(fid,nstr2,sgn,cm,sp);
	}

	return;
}
/*}}}*/
