/*!\file DatasetInput.c
 * \brief: implementation of the datasetinput object
 */
/*Headers{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../../classes.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../shared/shared.h"
/*}}}*/

/*DatasetInput constructors and destructor*/
/*FUNCTION DatasetInput::DatasetInput(){{{*/
DatasetInput::DatasetInput(){
	enum_type=UNDEF;
	inputs=NULL;
}
/*}}}*/
/*FUNCTION DatasetInput::DatasetInput(int in_enum_type) {{{*/
DatasetInput::DatasetInput(int in_enum_type){

	enum_type  = in_enum_type;
	inputs     = new Inputs();
}
/*}}}*/
/*FUNCTION DatasetInput::~DatasetInput(){{{*/
DatasetInput::~DatasetInput(){
	delete inputs;
}
/*}}}*/

/*Object virtual functions definitions:*/
		/*FUNCTION DatasetInput::Echo {{{*/
void DatasetInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DatasetInput::DeepEcho{{{*/
void DatasetInput::DeepEcho(void){

	_printLine_("DatasetInput:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("---inputs: "); inputs->Echo();
}
/*}}}*/
/*FUNCTION DatasetInput::Id{{{*/
int    DatasetInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DatasetInput::ObjectEnum{{{*/
int DatasetInput::ObjectEnum(void){

	return DatasetInputEnum;

}
/*}}}*/
/*FUNCTION DatasetInput::copy{{{*/
Object* DatasetInput::copy() {

	DatasetInput* output=NULL;

	output = new DatasetInput();
	output->enum_type=this->enum_type;
	output->inputs=(Inputs*)this->inputs->Copy();

	return output;
}
/*}}}*/
/*FUNCTION DatasetInput::SpawnTriaInput{{{*/
Input* DatasetInput::SpawnTriaInput(int* indices){

	/*output*/
	DatasetInput* outinput=NULL;

	/*Create new Datasetinput (copy of current input)*/
	outinput=new DatasetInput();
	outinput->enum_type=this->enum_type;
	outinput->inputs=dynamic_cast<Inputs*>(this->inputs->SpawnTriaInputs(indices));

	/*Assign output*/
	return outinput;
}
/*}}}*/

/*DatasetInput management*/
/*FUNCTION DatasetInput::InstanceEnum{{{*/
int DatasetInput::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/

/*Object functions*/
/*FUNCTION DatasetInput::Configure{{{*/
void DatasetInput::Configure(Parameters* parameters){
	/*do nothing: */
}
/*}}}*/
/*FUNCTION DatasetInput::GetInputValue(IssmDouble* pvalue,GaussTria* gauss,int index){{{*/
void DatasetInput::GetInputValue(IssmDouble* pvalue,GaussTria* gauss,int index){

	/*Get requested input within dataset*/
	if(index<0 || index > inputs->Size()-1) _error_("index requested (" << index << ") exceeds dataset size (" << inputs->Size() << ")");
	Input* input=dynamic_cast<Input*>(this->inputs->GetObjectByOffset(index));

	input->GetInputValue(pvalue,gauss);
}
/*}}}*/
