/*
 * \file Results.cpp
 * \brief: Implementation of the Results class, derived from DataSet class.
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../Params/Parameters.h"
#include "../../../shared/shared.h"
#include "./Results.h"
#include "./ExternalResult.h"
#include "../ElementResults/ElementResult.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Results::Results(){{{*/
Results::Results(){
	enum_type=ResultsEnum;
	return;
}
/*}}}*/
/*FUNCTION Results::~Results(){{{*/
Results::~Results(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Results::SpawnTriaResults{{{*/
Results* Results::SpawnTriaResults(int* indices){

	/*Intermediary*/
	vector<Object*>::iterator object;
	ElementResult* resultin=NULL;
	ElementResult* resultout=NULL;

	/*Output*/
	Results* newresults=new Results();

	/*Go through results and call Spawn function*/
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Create new result*/
		resultin=(ElementResult*)(*object); 
		resultout=resultin->SpawnTriaElementResult(indices);

		/*Add result to new results*/
		newresults->AddObject((Object*)resultout);
	}

	/*Assign output pointer*/
	return newresults;
}
/*}}}*/
/*FUNCTION Results::Write{{{*/
void Results::Write(Parameters* parameters){

	int         i;
	FILE       *fid          = NULL;
	bool        io_gather=true;

	/*Recover file descriptor: */
	parameters->FindParam(&fid,OutputFilePointerEnum);
	parameters->FindParam(&io_gather,SettingsIoGatherEnum);

	for(i=0;i<this->Size();i++){
		ExternalResult* result=dynamic_cast<ExternalResult*>(this->GetObjectByOffset(i));

		/*write result to disk: */
		result->WriteData(fid,io_gather);
	}

}
/*}}}*/
