/*!\file: prognostic_core.cpp
 * \brief: core of the prognostic solution 
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../shared/io/io.h"
#include "../shared/Enum/Enum.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void prognostic_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;
	bool issmbgradients,ispdd,isdelta18o;
	int  solution_type;
	int  *requested_outputs = NULL;
	int  numoutputs=0;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(PrognosticAnalysisEnum);

	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&issmbgradients,SurfaceforcingsIssmbgradientsEnum);
	femmodel->parameters->FindParam(&ispdd,SurfaceforcingsIspddEnum);
	femmodel->parameters->FindParam(&isdelta18o,SurfaceforcingsIsdelta18oEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);
	femmodel->parameters->FindParam(&numoutputs,PrognosticNumRequestedOutputsEnum);
	if(numoutputs) femmodel->parameters->FindParam(&requested_outputs,&numoutputs,PrognosticRequestedOutputsEnum);

	if(issmbgradients){
	  _printf_(VerboseSolution(),"	call smb gradients module\n");
	  SmbGradientsx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	}
	if(ispdd){
		if(isdelta18o){
			if(VerboseSolution()) _pprintLine_("   call Delta18oParametrization module");
			Delta18oParameterizationx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
		} 
		if(VerboseSolution()) _pprintLine_("   call positive degree day module");
		PositiveDegreeDayx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	}
	if(VerboseSolution()) _pprintLine_("   call computational core");
	solver_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
		femmodel->RequestedOutputsx(requested_outputs,numoutputs);
	}

	if(solution_type==PrognosticSolutionEnum)femmodel->RequestedDependentsx();

	/*Free ressources:*/
	xDelete<int>(requested_outputs);
}
