/*!\file:  WrapperCorePointerFromSolutionEnum.cpp
 * \brief: return type of analyses, number of analyses and core solution function.
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../shared/Enum/Enum.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void WrapperCorePointerFromSolutionEnum(void (**psolutioncore)(FemModel*),Parameters* parameters,int solutiontype,bool nodakotacore){

	/*output: */
	void (*solutioncore)(FemModel*)=NULL;

	/*parameters: */
	bool control_analysis=false;
	bool tao_analysis=false;
	bool dakota_analysis=false;

	/* retrieve some parameters that tell us whether wrappers are allowed, or whether we return 
	 * a pure core. Wrappers can be dakota_core (which samples many solution_cores) or control_core (which 
	 * carries out adjoint based inversion on a certain core: */
	parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);
	parameters->FindParam(&control_analysis,InversionIscontrolEnum);
	parameters->FindParam(&tao_analysis,InversionTaoEnum);

	if(nodakotacore)dakota_analysis=false;

	if(dakota_analysis){
		#ifdef _HAVE_DAKOTA_
		solutioncore=dakota_core;
		#else
		_error_("ISSM was not compiled with dakota support, cannot carry out dakota analysis!");
		#endif
	}
	else if(control_analysis){
		#ifdef _HAVE_CONTROL_
		if(tao_analysis) solutioncore=controltao_core;
		else solutioncore=control_core;
		#else
		_error_("ISSM was not compiled with control support, cannot carry out control analysis!");
		#endif
	}
	else CorePointerFromSolutionEnum(&solutioncore,parameters,solutiontype);  /*This means we retrieve a core solution that is not a wrapper*/

	/*Assign output pointer:*/
	_assert_(psolutioncore);
	*psolutioncore=solutioncore;

}
