/*!\file:  adjointbalancethickness_core.cpp
 * \brief compute inverse method adjoint state
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../shared/io/io.h"
#include "../shared/Enum/Enum.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void adjointbalancethickness_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	/*compute thickness */
	if(VerboseSolution()) _pprintLine_("   computing thickness");
	femmodel->SetCurrentConfiguration(BalancethicknessAnalysisEnum);
	solver_linear(femmodel);

	/*Call SurfaceAreax, because some it might be needed by PVector*/
	SurfaceAreax(NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);

	/*compute adjoint*/
	if(VerboseSolution()) _pprintLine_("   computing adjoint");
	femmodel->SetCurrentConfiguration(BalancethicknessAnalysisEnum,AdjointBalancethicknessAnalysisEnum);
	solver_adjoint_linear(femmodel);

	/*Save results*/
	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointEnum);
	}
}
