/*!\file: controlconvergence.cpp
 * \brief: determine convergence of control_core solution
 */ 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./analyses.h"
#include "../classes/objects/objects.h"
#include "../shared/io/io.h"
#include "../Container/Container.h"
#include "../shared/Enum/Enum.h"
#include "../modules/modules.h"

bool controlconvergence(IssmDouble J, IssmDouble tol_cm){

	bool converged=false;

	/*Has convergence been reached?*/
	if (!xIsNan<IssmDouble>(tol_cm) && J<tol_cm){
		converged=true;
		if(VerboseConvergence()) _pprintString_("      Convergence criterion reached: J = " << J << " < " << tol_cm);
	}

	return converged;
}
