/*!\file: DependentObject.h
 * \brief prototype for DependentObject.h
 */ 

#ifndef _DEPENDENTOBJECT_H_
#define  _DEPENDENTOBJECT_H_

/*{{{*/
#include "./Object.h"
#include "../../shared/shared.h"
/*}}}*/

class FemModel;

class DependentObject: public Object{

	public:

		int name;
		int type;  /*0: scalar, 1: vertex*/
		int index;  /*0: scalar, 1: vertex*/

		/*DependentObject constructors, destructors {{{*/
		DependentObject();
		DependentObject(int name, int type,int index);
		~DependentObject();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy(void);
		/*}}}*/

		/*DependentObject methods: */
		int  NumDependents(void);
		void Responsex(IssmDouble* poutput_value,FemModel* femmodel);

};
#endif //ifndef _DEPENDENTOBJECT_H_
