/*!\file SmbGradientsx
 * \brief: calculates SMB as function of local elevation 
 */

#include "./SmbGradientsx.h"
#include "../../shared/shared.h"
#include "../../shared/io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../shared/Enum/Enum.h"

void SmbGradientsx(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters){

// void SmbGradientsx(hd,agd,ni){
//    INPUT parameters: ni: working size of arrays
//    INPUT: surface elevation (m): hd(NA)
//    OUTPUT: mass-balance (m/yr ice): agd(NA)

  int    i;

  Element* element = NULL;

  for(i=0;i<elements->Size();i++){
    element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
    element->SmbGradients();
  }
}
