/*! \file CreateLoadsHydrologyDCInefficient.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../shared/io/io.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsHydrologyDCInefficient(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int      hydrology_model;
	int      numberofvertices;
	Pengrid *pengrid = NULL;

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Fetch parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads();

	if(hydrology_model!=HydrologydcEnum){
		*ploads=loads;
		return;
	}

	//create penalties for nodes: no node can have a temperature over the melting point
	iomodel->FetchData(1,MeshElementsEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for(int i=0;i<numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){
			loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,HydrologyDCInefficientAnalysisEnum));
		}
	}
	iomodel->DeleteData(1,MeshElementsEnum);

	/*Assign output pointer: */
	*ploads=loads;
}
