/*!\file InputUpdateFromSolutionx
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromSolutionx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../../shared/Enum/Enum.h"

void InputUpdateFromSolutionx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,Vector<IssmDouble>* solution){

	IssmDouble* serial_solution=NULL;

	/*Serialize solution, so that elements can index into it on every CPU: */
	serial_solution=solution->ToMPISerial();

	/*Call overloaded form of InputUpdateFromSolutionx: */
	InputUpdateFromSolutionx( elements, nodes,  vertices,  loads,  materials,  parameters,serial_solution);

	/*Free ressources:*/
	xDelete<IssmDouble>(serial_solution);
}

void InputUpdateFromSolutionx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,IssmDouble* solution){

	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*Elements drive the update: */
	for (i=0;i<elements->Size();i++){
		element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->InputUpdateFromSolution(solution);
	}
}
