/*!\file MatrixParam.c
 * \brief: implementation of the MatrixParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../shared/shared.h"
#include "../../../Container/Container.h"
/*}}}*/

/*MatrixParam constructors and destructor*/
/*FUNCTION MatrixParam::MatrixParam(){{{*/
MatrixParam::MatrixParam(){
	return;
}
/*}}}*/
/*FUNCTION MatrixParam::MatrixParam(int enum_type,Matrix<IssmDouble>* value){{{*/
MatrixParam::MatrixParam(int in_enum_type,Matrix<IssmDouble>* in_value){

	enum_type=in_enum_type;
	value=NULL;

	if(in_value){
		value=in_value->Duplicate();
	}
}
/*}}}*/
/*FUNCTION MatrixParam::~MatrixParam(){{{*/
MatrixParam::~MatrixParam(){
	delete value;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION MatrixParam::Echo {{{*/
void MatrixParam::Echo(void){

	_printLine_("MatrixParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");

}
/*}}}*/
/*FUNCTION MatrixParam::DeepEcho{{{*/
void MatrixParam::DeepEcho(void){

	_printLine_("MatrixParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	this->value->Echo();
}
/*}}}*/
/*FUNCTION MatrixParam::Id{{{*/
int    MatrixParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION MatrixParam::ObjectEnum{{{*/
int MatrixParam::ObjectEnum(void){

	return MatrixParamEnum;

}
/*}}}*/
/*FUNCTION MatrixParam::copy{{{*/
Object* MatrixParam::copy() {

	return new MatrixParam(this->enum_type,this->value);

}
/*}}}*/

/*MatrixParam virtual functions definitions: */
/*FUNCTION MatrixParam::GetParameterValue{{{*/
void  MatrixParam::GetParameterValue(Matrix<IssmDouble>** poutput){
	Matrix<IssmDouble>* output=NULL;

	if(value){
		output=value->Duplicate();
	}
	*poutput=output;
}
/*}}}*/
/*FUNCTION MatrixParam::GetParameterName{{{*/
void MatrixParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION MatrixParam::SetValue{{{*/
void  MatrixParam::SetValue(Matrix<IssmDouble>* matrix){

	/*avoid leak: */
	delete value;

	/*copy: */
	value=matrix->Duplicate();
}
/*}}}*/
/*FUNCTION MatrixParam::UnitConversion{{{*/
void  MatrixParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
