/*!\file IntMatParam.c
 * \brief: implementation of the IntMatParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../shared/shared.h"
#include "../../../Container/Container.h"
/*}}}*/

/*IntMatParam constructors and destructor*/
/*FUNCTION IntMatParam::IntMatParam(){{{*/
IntMatParam::IntMatParam(){
	return;
}
/*}}}*/
/*FUNCTION IntMatParam::IntMatParam(int enum_type,IssmIntMat value){{{*/
IntMatParam::IntMatParam(int in_enum_type,int* in_value, int in_M,int in_N){

	enum_type=in_enum_type;
	M=in_M;
	N=in_N;

	value=xNew<int>(M*N);
	xMemCpy<int>(value,in_value,M*N);
}
/*}}}*/
/*FUNCTION IntMatParam::~IntMatParam(){{{*/
IntMatParam::~IntMatParam(){
	xDelete<int>(value);
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION IntMatParam::Echo {{{*/
void IntMatParam::Echo(void){

	_printLine_("IntMatParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   matrix size: " << this->M << "x" << this->N);

}
/*}}}*/
/*FUNCTION IntMatParam::DeepEcho{{{*/
void IntMatParam::DeepEcho(void){

	int i,j;

	_printLine_("IntMatParam:");
	_printLine_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")");
	_printLine_("   matrix size: " << this->M << "x" << this->N);
	for(i=0;i<this->M;i++){
		for(i=0;i<this->N;i++){
			_printLine_("(" << i << "," << j << ") " << *(this->value+N*i+j));
		}
	}
}
/*}}}*/
/*FUNCTION IntMatParam::Id{{{*/
int    IntMatParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION IntMatParam::ObjectEnum{{{*/
int IntMatParam::ObjectEnum(void){

	return IntMatParamEnum;

}
/*}}}*/
/*FUNCTION IntMatParam::copy{{{*/
Object* IntMatParam::copy() {

	return new IntMatParam(this->enum_type,this->value,this->M,this->N);

}
/*}}}*/

/*IntMatParam virtual functions definitions: */
/*FUNCTION IntMatParam::GetParameterValue{{{*/
void  IntMatParam::GetParameterValue(int** pintarray,int* pM,int* pN){
	int* output=NULL;

	output=xNew<int>(M*N);
	xMemCpy<int>(output,value,M*N);

	/*Assign output pointers:*/
	if(pM) *pM=M;
	if(pN) *pN=N;
	*pintarray=output;
}
/*}}}*/
/*FUNCTION IntMatParam::GetParameterName{{{*/
void IntMatParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION IntMatParam::SetValue{{{*/
void  IntMatParam::SetValue(int* intarray,int in_M,int in_N){

	/*avoid leak: */
	xDelete<int>(this->value);

	this->value=xNew<int>(in_M*in_N);
	xMemCpy<int>(this->value,intarray,in_M*in_N);

	this->M=in_M;
	this->N=in_N;
}
/*}}}*/
/*FUNCTION IntMatParam::UnitConversion{{{*/
void  IntMatParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
