/*!\file ResetConstraintsx
 * \brief: reset thermal penalties
 */

#include "./ResetConstraintsx.h"
#include "../../shared/shared.h"
#include "../../shared/io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../shared/Enum/Enum.h"
#include "../ConstraintsStatex/ConstraintsStatex.h"

void ResetConstraintsx(Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads,Materials* materials,  Parameters* parameters){

	/*output: */
	int analysis_type;

	/*Display message*/
	if(VerboseModule()) _pprintLine_("   Resetting penalties");

	/*recover parameters: */
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*Do we have penalties linked to rifts? In this case, run our special rifts penalty 
	 * management routine, otherwise, skip : */
	if (RiftIsPresent(loads,analysis_type)){
		_error_("rift constraints reset not supported yet!");
	}
	else if(ThermalIsPresent(loads,analysis_type)){
		ThermalConstraintsReset(loads,analysis_type);
	}
	else{ /*Do nothing, no constraints management!:*/}

}
