/*!\file NodesDofx
 * \brief: establish degrees of freedom for all nodes
 */

#include "./NodesDofx.h"

#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../../shared/Enum/Enum.h"

void NodesDofx(Nodes* nodes, Parameters* parameters,int configuration_type){

	int noerr=1;
	int found=0;

	/*Do we have any nodes for this analysis type? :*/
	if(nodes->NumberOfNodes(configuration_type)){ 

		/*Ensure that only for each cpu, the partition border nodes only will be taken into account once 
		 * across the cluster. To do so, we flag all the clone nodes: */
		nodes->FlagClones(configuration_type);

		/*Go through all nodes, and build degree of freedom lists. Each node gets a fixed number of dofs. When 
		 *a  node has already been distributed dofs on one cpu, all other cpus with the same node cannot distribute it 
		 *anymore. Use clone field to be sure of that: */
		nodes->DistributeDofs(configuration_type,GsetEnum);
		nodes->DistributeDofs(configuration_type,FsetEnum);
		nodes->DistributeDofs(configuration_type,SsetEnum);
	}

}
