/*! \file CreateLoadsMelting.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../shared/io/io.h"
#include "../../../shared/Enum/Enum.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsMelting(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int dim;
	int numberofvertices;
	iomodel->Constant(&dim,MeshDimensionEnum);
	iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);

	/*if 2d: Error*/
	if (dim==2) _error_("2d meshes not supported yet");

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads();

	//create penalties for nodes: no node can have a temperature over the melting point
	iomodel->FetchData(2,MeshVertexonbedEnum,MeshElementsEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for(int i=0;i<numberofvertices;i++){
		if((iomodel->my_vertices[i]==1)){
			if (reCast<int>(iomodel->Data(MeshVertexonbedEnum)[i])){
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,MeltingAnalysisEnum));
			}
		}
	}
	iomodel->DeleteData(2,MeshVertexonbedEnum,MeshElementsEnum);

	/*Assign output pointer: */
	*ploads=loads;
}
