/*!\file: steadystateconvergence.cpp
 * \brief: determine convergence of steady state solution
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes/objects/objects.h"
#include "../shared/shared.h"
#include "../Container/Container.h"
#include "../shared/Enum/Enum.h"
#include "../modules/modules.h"
#include "./solutions.h"

bool steadystateconvergence(FemModel* femmodel){

	/*output: */
	bool converged=false;
	bool velocity_converged=false;
	bool temperature_converged=false;

	/*intermediary: */
	int velocityenums[8]={VxEnum,VxPicardEnum,VyEnum,VyPicardEnum,VzEnum,VzPicardEnum,PressureEnum,PressurePicardEnum}; //pairs of enums (new and old) on which to carry out the converence tests
	int temperatureenums[2]={TemperatureEnum,TemperatureOldEnum};
	int convergencecriterion[1]={RelativeEnum}; //criterions for convergence, RelativeEnum or AbsoluteEnum 
	IssmDouble convergencecriterionvalue[1]; //value of criterion to be respected

	/*retrieve parameters: */
	femmodel->parameters->FindParam(&convergencecriterionvalue[0],SteadystateReltolEnum);

	/*figure out convergence at the input level, because we don't have the solution vectors!: */
	velocity_converged=InputConvergencex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,&velocityenums[0],8,&convergencecriterion[0],&convergencecriterionvalue[0],1);
	temperature_converged=InputConvergencex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,&temperatureenums[0],2,&convergencecriterion[0],&convergencecriterionvalue[0],1);

	if(velocity_converged && temperature_converged) converged=true;

	/*return: */
	return converged;
}
