/*!\file InputUpdateFromVectorx
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromVectorx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../../shared/Enum/Enum.h"

void InputUpdateFromVectorx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,Vector<IssmDouble>* vector, int name, int type){

	IssmDouble* serial_vector=NULL;

	serial_vector=vector->ToMPISerial();

	InputUpdateFromVectorx( elements,nodes, vertices, loads, materials, parameters,serial_vector,name, type);

	/*Free ressources:*/
	xDelete<IssmDouble>(serial_vector);
}

void InputUpdateFromVectorx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,IssmDouble* vector, int name, int type){

	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,name,type);
	}
}

void InputUpdateFromVectorx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,int* vector, int name, int type){

	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,name,type);
	}
}

void InputUpdateFromVectorx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,bool* vector, int name, int type){

	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVector(vector,name,type);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVector(vector,name,type);
	}
}
