/*!\file InputUpdateFromVectorDakotax
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromVectorDakotax.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../../shared/Enum/Enum.h"

void InputUpdateFromVectorDakotax( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,Vector<IssmDouble>* vector, int name, int type){

	double* serial_vector=NULL;

	serial_vector=vector->ToMPISerial();

	InputUpdateFromVectorDakotax( elements,nodes, vertices, loads, materials, parameters,serial_vector,name, type);

	/*Free ressources:*/
	xDelete<double>(serial_vector);
}

void InputUpdateFromVectorDakotax( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,double* vector, int name, int type){

	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVectorDakota(vector,name,type);
	}
}

void InputUpdateFromVectorDakotax( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,int* vector, int name, int type){

	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVectorDakota(vector,name,type);
	}
}

void InputUpdateFromVectorDakotax( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,bool* vector, int name, int type){

	int i;

	/*Update elements, nodes, loads and materials from inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<nodes->Size();i++){
		Node* node=(Node*)nodes->GetObjectByOffset(i);
		node->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<loads->Size();i++){
		Load* load=(Load*)loads->GetObjectByOffset(i);
		load->InputUpdateFromVectorDakota(vector,name,type);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputUpdateFromVectorDakota(vector,name,type);
	}
}
