/*!\file Delta18oParameterizationx
 * \brief: Create past temperature field from present day fields
 */

#include "./Delta18oParameterizationx.h"
#include "../../shared/shared.h"
#include "../../shared/io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../shared/Enum/Enum.h"

void Delta18oParameterizationx(Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters){

  /*Intermediary*/
  int    i;
  Element* element = NULL;

  /*Compute temperature and precipitation fields: */
  for(i=0;i<elements->Size();i++){
    element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
    element->Delta18oParameterization();
  }  
}
