/*
 * \file Materials.cpp
 * \brief: Implementation of Materials class, derived from DataSet class.
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Materials.h"
#include "../shared/shared.h"
#include "../shared/Enum/Enum.h"
#include "../classes/objects/Materials/Material.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION Materials::Materials(){{{*/
Materials::Materials(){
	enum_type=MaterialsEnum;
	return;
}
/*}}}*/
/*FUNCTION Materials::~Materials(){{{*/
Materials::~Materials(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Materials::Configure{{{*/
void Materials::Configure(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters){

	vector<Object*>::iterator object;
	Material* material=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		material=dynamic_cast<Material*>(*object);
		material->Configure(elements);

	}

}
/*}}}*/
