#ifndef _CONTAINER_PARAMETERS_H_
#define  _CONTAINER_PARAMETERS_H_
#include <stdio.h>

/*forward declarations */
template <class doublematrix> class Matrix;
template <class doubletype> class Vector;
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class Inputs;
#include "./DataSet.h"
#include "../shared/Numerics/types.h"

/*!\brief Declaration of Parameters class.  
 *
 * Declaration of Parameters class.  Parameters are vector lists (Containers) of Parameter objects.
 */ 
class Parameters: public DataSet{

	public:

		/*constructors, destructors*/ 
		Parameters();
		~Parameters();

		/*numerics*/
		bool  Exist(int enum_type);

		void  FindParam(bool* pinteger,int enum_type);
		void  FindParam(int* pinteger,int enum_type);
		void  FindParam(IssmDouble* pscalar, int enum_type);
		void  FindParam(IssmDouble* pscalar, int enum_type,IssmDouble time);
		void  FindParam(char** pstring,int enum_type);
		void  FindParam(char*** pstringarray,int* pM,int enum_type);
		void  FindParam(int** pintarray,int* pM,int enum_type);
		void  FindParam(int** pintarray,int* pM,int* PN,int enum_type);
		void  FindParam(IssmDouble** pIssmDoublearray,int* pM,int enum_type);
		void  FindParam(IssmDouble** pIssmDoublearray,int* pM,int* pN,int enum_type);
		void  FindParam(IssmDouble*** parray,int* pM, int** pmdims_array,int** pndims_array,int enum_type);
		void  FindParam(Vector<IssmDouble>** pvec,int enum_type);
		void  FindParam(Matrix<IssmDouble>** pmat,int enum_type);
		void  FindParam(FILE** pfid,int enum_type);
		void  FindParam(DataSet** pdataset, int enum_type);

		void  SetParam(bool boolean,int enum_type);
		void  SetParam(int integer,int enum_type);
		void  SetParam(IssmDouble scalar, int enum_type);
		void  SetParam(char* string,int enum_type);
		void  SetParam(char** stringarray,int M,int enum_type);
		void  SetParam(IssmDouble* IssmDoublearray,int M,int enum_type);
		void  SetParam(IssmDouble* IssmDoublearray,int M,int N,int enum_type);
		void  SetParam(int* intarray,int M,int enum_type);
		void  SetParam(int* intarray,int M,int N,int enum_type);
		void  SetParam(Vector<IssmDouble>* vec,int enum_type);
		void  SetParam(Matrix<IssmDouble>* mat,int enum_type);
		void  SetParam(FILE* fid,int enum_type);
		void  UnitConversion(int direction_enum);

		Object* FindParamObject(int enum_type);

};

#endif //ifndef _PARAMETERS_H_
