#ifndef _CONTAINER_DATASET_H_
#define _CONTAINER_DATASET_H_

#include <vector>
#include <cstring>
#include "../classes/objects/Contour.h"

/*forward declarations */
class Object;
class Elements;
class Loads;
class Nodes;
class Vertices;
class Materials;
class Parameters;
class Patch;
class Results;
class Patch;

/*! \brief Declaration of DataSet class
 *
 * Declaration of DataSet class.  A DataSet is a Container of Objects.
 */
class DataSet{

	public: 

		/*internals: */
		std::vector<Object*> objects;

		/*type of dataset: */
		int             enum_type;

		/*sorting: */
		int             sorted;
		int             presorted;
		int*            sorted_ids;
		int*            id_offsets;

		/*constructors, destructors*/
		DataSet();
		DataSet(int enum_type);
		~DataSet();

		/*management*/
		int      GetEnum();
		int      GetEnum(int offset);
		void     Echo();
		void     DeepEcho();
		int      AddObject(Object *object);
		int      DeleteObject(int id);
		int      Size();
		void     clear();
		Object  *GetObjectByOffset(int  offset);
		Object  *GetObjectById(int *poffset,int eid);
		void     Presort();
		void     Sort();
		DataSet *Copy(void);
		int      DeleteObject(Object *object);
		Results *SpawnTriaResults(int *indices);

};

/*Methods that relate to datasets: */
int ExpWrite(DataSet* contours,char* domainname);
template <class doubletype> DataSet* ExpRead(char* domainname){ /*{{{*/

	/*intermediary: */
	int                  nprof;
	int                 *profnvertices = NULL;
	doubletype         **pprofx        = NULL;
	doubletype         **pprofy        = NULL;

	/*output: */
	DataSet *domain = NULL;

	/*If domainname is an empty string, return empty dataset*/
	if (strcmp(domainname,"")==0){
		nprof=0;
	}
	else{
		ExpRead(&nprof,&profnvertices,&pprofx, &pprofy, NULL,domainname);
	}

	/*now create dataset of contours: */
	domain=new DataSet(0);

	for(int i=0;i<nprof;i++){
		domain->AddObject(new Contour<doubletype>(i,profnvertices[i],pprofx[i],pprofy[i],1));
	}
	return domain;
} /*}}}*/

#endif
