/*
 * TriMesh: mesh a domain using an .exp file
 */

#include "./TriMesh.h"

void TriMeshUsage(void){/*{{{*/
	_printLine_("");
	_printLine_("   usage: [index,x,y,segments,segmentmarkers]=TriMesh(domainoutlinefilename,rifts,area) ");
	_printLine_("      where: index,x,y defines a triangulation, segments is an array made ");
	_printLine_("      of exterior segments to the mesh domain outline, segmentmarkers is an array flagging each segment, ");
	_printLine_("      outlinefilename an Argus domain outline file, ");
	_printLine_("      area is the maximum area desired for any element of the resulting mesh, ");
	_printLine_("");
}/*}}}*/
WRAPPER(TriMesh){
	
	/*intermediary: */
	double   area;
	DataSet *domain = NULL;
	DataSet *rifts  = NULL;

	/* output: */
	int    *index             = NULL;
	double *x                 = NULL;
	double *y                 = NULL;
	int    *segments          = NULL;
	int    *segmentmarkerlist = NULL;
	int     nels,nods,nsegs;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&TriMeshUsage);
	
	/*Fetch data needed for meshing: */
	FetchData(&domain,DOMAINOUTLINE);
	FetchData(&rifts,RIFTSOUTLINE);
	FetchData(&area,AREA);

	/*call x core: */
	TriMeshx(&index,&x,&y,&segments,&segmentmarkerlist,&nels,&nods,&nsegs,domain,rifts,area);

	/*write outputs: */
	WriteData(INDEX,index,nels,3);
	WriteData(X,x,nods);
	WriteData(Y,y,nods);
	WriteData(SEGMENTS,segments,nsegs,3);
	WriteData(SEGMENTMARKERLIST,segmentmarkerlist,nsegs);

	/*free ressources: */
	delete domain;
	delete rifts;
	xDelete<int>(index);
	xDelete<double>(x);
	xDelete<double>(y);
	xDelete<int>(segments);
	xDelete<int>(segmentmarkerlist);

	/*end module: */
	MODULEEND();
}
