/*
 * \file Constraints.cpp
 * \brief: Implementation of Constraints class, derived from DataSet class.
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Constraints.h"
#include "../shared/io/Print/Print.h"
#include "../toolkits/mpi/mpiincludes.h"

using namespace std;
/*}}}*/


/*Numerics: */
/*FUNCTION Constraints::NumberOfConstraints{{{*/
int Constraints::NumberOfConstraints(void){

	int localconstraints;
	int numberofconstraints;

	/*Get number of local constraints*/
	localconstraints=this->Size();

	/*figure out total number of constraints combining all the cpus (no clones here)*/
	#ifdef _HAVE_MPI_
		MPI_Reduce(&localconstraints,&numberofconstraints,1,MPI_INT,MPI_SUM,0,IssmComm::GetComm() );
		MPI_Bcast(&numberofconstraints,1,MPI_INT,0,IssmComm::GetComm());
	#else
		numberofconstraints=localconstraints;
	#endif

	return numberofconstraints;
}
/*}}}*/
