#ifndef _CONTAINER_ELEMENTS_H_
#define  _CONTAINER_ELEMENTS_H_

/*forward declarations */
#include "./DataSet.h"
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class Inputs;

/*! \brief Declaration of Elements class 
 *
 * Declaration of Elements class.  Elements are vector lists (Containers) of Element objects.
 */ 
class Elements: public DataSet{

	public:

		/*constructors, destructors*/
		Elements();
		~Elements();

		/*numerics*/
		void   Configure(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters);
		void   DeleteResults(void);
		int    MaxNumNodes(void);
		void   ProcessResultsUnits(void);
		void   SetCurrentConfiguration(Elements* elements,Loads* loads, Nodes* nodes, Vertices* vertices, Materials* materials,Parameters* parameters);
		void   ToResults(Results* results,Parameters* parameters);
		Patch* ResultsToPatch(void);
		int    NumberOfElements(void);
		void   InputDuplicate(int input_enum,int output_enum);

};

#endif //ifndef _ELEMENTS_H_
