/*!\file: gia_core.cpp
 * \brief: core of the GIA solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../shared/io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void gia_core(FemModel* femmodel){

	int i;
	Vector<IssmDouble>*  wg  = NULL;
	Vector<IssmDouble>*  dwgdt  = NULL;
	IssmDouble*          x   = NULL;
	IssmDouble*          y   = NULL;

	/*parameters: */
	bool save_results;
	int  gsize;
	int  configuration_type;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&configuration_type,ConfigurationTypeEnum);

	if(VerboseSolution()) _pprintLine_("   computing GIA");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(GiaAnalysisEnum);

	/*Figure out size of g-set deflection vector and allocate solution vector: */
	gsize      = femmodel->nodes->NumberOfDofs(configuration_type,GsetEnum);
	wg = new Vector<IssmDouble>(gsize);
	dwgdt = new Vector<IssmDouble>(gsize);

	/*first, recover x and y vectors from vertices: */
	VertexCoordinatesx(&x,&y,NULL,femmodel->vertices); //no need for z coordinate

	/*call the main module: */
	femmodel->Deflection(wg,dwgdt,x,y);

	/*assemble vector: */
	wg->Assemble();
	dwgdt->Assemble();

	InputUpdateFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,wg); 
	InputUpdateFromVectorx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,dwgdt,GiadWdtEnum,VertexEnum); 

	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,GiaWEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,GiadWdtEnum);
	}

}
