/*!\file: ResetBoundaryConditions.cpp
 * \brief: change boundary conditions of a model, using a solution vector from another analysis
 */ 

#include "../classes/objects/objects.h"
#include "../modules/modules.h"
#include "../shared/io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ResetBoundaryConditions(FemModel* femmodel, int analysis_type){

	/*variables: */
	Vector<IssmDouble>*    yg    = NULL;
	Nodes *nodes = NULL;

	if(VerboseSolution()) _pprintLine_("   updating boundary conditions...");

	/*set current analysis: */
	femmodel->SetCurrentConfiguration(analysis_type);

	/*recover nodes: */
	nodes=femmodel->nodes;

	/*retrieve boundary conditions from element inputs :*/
	GetSolutionFromInputsx( &yg, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,  femmodel->parameters);

	/*update spcs using this new vector of constraints: */
	UpdateDynamicConstraintsx(femmodel->constraints,femmodel->nodes,femmodel->parameters,yg);

	/*Free ressources:*/
	delete yg;
}
